/**
 ******************************************************************************
 **	t@C : getc_sample.cpp
 **
 **	Tv       : 24NxsGreenETChallenge2012@eXgs̃vO
 **        : NPO@l QUEST Naohito.Yamashita 2012/10/31
 ** C       : 
 **
 ******************************************************************************
 **/

#include <string.h>
#include "kernel.h"
#include "kernel_id.h"
#include "ecrobot_interface.h"
#include "getc_define.h"
#include "nxt.h"
#include "motor.h"
#include "motor_controller.h"
#include "sensor.h"
#include "display.h"
#include "battery.h"
#include "getc_sample.h"

#include "power_meter.h"


DeclareEvent(Event2ms);
DeclareEvent(Event4ms);
DeclareCounter(SysTimerCnt);
DeclareTask(TaskMain);

static U8 v0 = 0;
static U8 v1 = 0;
static double dv0 = 0.0;
static double dv1 = 0.0;
static double pow = 0.0;


void ecrobot_device_initialize(){
	ecrobot_init_bt_slave(BT_SLAVE);/*BlueTooth X[uݒ*/
}

void ecrobot_device_terminated(){
	ecrobot_term_bt_connection();
}
//*****************************************************************************
// ֐	: user_1ms_isr_type2
// 		: Ȃ
// ߂l	: Ȃ
// Tv		: 1msec荞݃tbN֐(OSEK ISR type2JeS)
//*****************************************************************************
void user_1ms_isr_type2(void){
  static int ms=0;

	StatusType ercd;
	// Increment System Timer Count 
  ercd = SignalCounter(SysTimerCnt);
  if (ercd != E_OK)
  {
      ShutdownOS(ercd);
  }
  ms++;
  if ((ms % 2) == 0)
  {
    SetEvent(TaskMain, Event2ms);
  }
  if ((ms % 4) == 0)
	{
    SetEvent(TaskMain, Event4ms);
	}
}
void wait_event()
{
  WaitEvent(Event4ms); //4msec҂
  ClearEvent(Event4ms);//tONA
}

double power()
{

	Pmr_adc(NXT_PORT_S4);
	v0 = Pmr_get_v0();
	v1 = Pmr_get_v1();
		
	dv0 = (double)v0;
	dv1 = (double)v1;
		
	dv0 = (dv0 * 2.5)/255.0; //dϊ
	dv1 = (dv1 * 2.5)/255.0; //dϊ
		
	dv0 = dv0 * 4.0; // 1/4ɕɖ߂B
	dv1 = dv1 * 4.0; // 1/4ɕɖ߂B
		
	pow = dv0 * (dv0 - dv1) * 10.0;//d͂̌vZ
	return pow;
}

//*****************************************************************************
// ^XN	: TaskMain
// Tv		: C^XN
//*****************************************************************************

TASK(TaskMain)
{
	int up;
	int dn;
	int counter = 0;
	static double pow = 0.0;
	
	display_clear(1);
	display_update();
	
	Pmr_init(NXT_PORT_S4);
		
	MotorController_run(100);

	while (1){
		MotorController_run(100);
    pow += power();
		if (counter > 125 || counter <250){
			MotorController_stop();
		}
		if (0 == (counter % 250)){
			counter = 0;
      pow = pow / 250.0;
			up = (int)pow;
			dn = (int)((pow - up)*10.0);(dn < 0 ? dn=dn * -1:dn);
			display_goto_xy(0,0);
			display_int(up , 0);
			display_string(".");
			display_int(dn , 0);
			display_string("Watt     ");

			up = (int)dv0;
			dn = (int)((dv0 - up)*10.0);(dn < 0 ? dn=dn * -1:dn);
			display_goto_xy(0,1);
			display_int(up , 0);
			display_string(".");
			display_int(dn , 0);
			display_string("dv0     ");

			up = (int)dv1;
			dn = (int)((dv1 - up)*10.0);(dn < 0 ? dn=dn * -1:dn);
			display_goto_xy(0,2);
			display_int(up , 0);
			display_string(".");
			display_int(dn , 0);
			display_string("dv1     ");

			display_update();
			pow = 0.0;
  	}
		counter++;
		systick_wait_ms(4);
}

//	Manager_init();
//	Manager_carlibration();
//	Manager_loop();
	
}
