/**
 ******************************************************************************
 **	t@C : getc_sample.cpp
 **
 **	Tv       : 24NxsGreenETChallenge2012@eXgs̃vO
 **        : NPO@l QUEST Naohito.Yamashita 2012/10/31
 ** C       : 
 **
 ******************************************************************************
 **/

#include <string.h>
#include "kernel.h"
#include "kernel_id.h"
#include "ecrobot_interface.h"
#include "getc_define.h"
#include "nxt.h"
#include "motor.h"
#include "motor_controller.h"
#include "sensor.h"
#include "bluetooth.h"
#include "display.h"
#include "battery.h"
#include "pc_manager.h"
#include "manager.h"
#include "getc_sample.h"

DeclareEvent(Event2ms);
DeclareEvent(Event4ms);
DeclareCounter(SysTimerCnt);
DeclareTask(TaskMain);

void ecrobot_device_initialize(){
	ecrobot_init_bt_slave(BT_SLAVE);/*BlueTooth X[uݒ*/
}

void ecrobot_device_terminated(){
	ecrobot_term_bt_connection();
}
//*****************************************************************************
// ֐	: user_1ms_isr_type2
// 		: Ȃ
// ߂l	: Ȃ
// Tv		: 1msec荞݃tbN֐(OSEK ISR type2JeS)
//*****************************************************************************
void user_1ms_isr_type2(void){
  static int ms=0;

	StatusType ercd;
	// Increment System Timer Count 
  ercd = SignalCounter(SysTimerCnt);
  if (ercd != E_OK)
  {
      ShutdownOS(ercd);
  }
  ms++;
  if ((ms % 2) == 0)
  {
    SetEvent(TaskMain, Event2ms);
  }
  if ((ms % 4) == 0)
	{
    SetEvent(TaskMain, Event4ms);
	}
  if (ms == 10)
	{
		PcManager_rec_send();
		ms=0;
	}
}
void wait_event()
{
  WaitEvent(Event4ms); //4msec҂
  ClearEvent(Event4ms);//tONA
}
//*****************************************************************************
// ^XN	: TaskMain
// Tv		: C^XN
//*****************************************************************************

TASK(TaskMain)
{
	Manager_init();
	Manager_carlibration();
	Manager_loop();
	
}
