#include <string.h>
#include "kernel.h"
#include "kernel_id.h"
#include "ecrobot_interface.h"

#include "getc_define.h"
#include "motor.h"
#include "motor_controller.h"
#include "getc_sample.h"

static 	double current;
static	double previous ;
static	double integral;

#define KP 0.26   
#define KI 0.00   
#define KD 0.027  
#define DELTA 0.004

static	int forward;
static	int state;

void MotorController_init( int f ){
	current  = 0.0;
	previous = 0.0;
	integral = 0.0;
	state = STATE_NO_RUN;

	forward = f;
}
double MotorController_pid(double sensor , double target){
	double p,i,d;
	previous = current;	
	current = sensor - target;
	integral += (current + previous) / 2.0 * DELTA;
	p = KP * current;
	i = KI * integral;
	d = KD * (current - previous) / DELTA;
	return (p + i + d);
}
void MotorController_run(int f)
{
	forward = f;
	Motor_run_motor(NXT_PORT_A, forward);
	Motor_run_motor(NXT_PORT_B, forward);
}
void MotorController_stop()
{
	Motor_stop_motor(NXT_PORT_A);
	Motor_stop_motor(NXT_PORT_B);
	forward = 0;
}

//turn ֐

void MotorController_turn (int tn)
{
	if (0 != forward){
		if ( forward < tn )	{tn =  forward;}else{}
		if (-forward > tn )	{tn = -forward;}else{}

		if (0 < tn){
			Motor_run_motor(NXT_PORT_B, forward);
			Motor_run_motor(NXT_PORT_A, forward/(tn));
		}
		else if (0 > tn ){
			Motor_run_motor(NXT_PORT_B, -forward/(tn));
			Motor_run_motor(NXT_PORT_A, forward);
		}else {
			Motor_run_motor(NXT_PORT_B,forward);
			Motor_run_motor(NXT_PORT_A,forward);
		}
	}
}
void MotorController_state_machine(int event){
	switch (state){
		case STATE_NO_RUN:
			if (EVENT_STOP == event){
				MotorController_func_no_run_stop();
			}else if (EVENT_START == event){
				MotorController_func_no_run_start();
				state = STATE_RUN;
			}
			break;
		case STATE_RUN:
			if (EVENT_STOP == event){
				MotorController_func_run_stop();
				state = STATE_NO_RUN;
			}else if (EVENT_START == event){
				MotorController_func_run_start();
			}
			break;
		default:
			break;
	}
}
void MotorController_func_no_run_start(){
	MotorController_run(100);
}
void MotorController_func_no_run_stop (){
}
void MotorController_func_run_start(){
}
void MotorController_func_run_stop (){
	MotorController_run(0);
}

