#include <string.h>
#include "kernel.h"
#include "kernel_id.h"
#include "ecrobot_interface.h"
#include "getc_define.h"
#include "nxt.h"
#include "motor.h"
#include "motor_controller.h"
#include "sensor.h"
#include "bluetooth.h"
#include "display.h"
#include "battery.h"
#include "pc_manager.h"
#include "manager.h"
#include "getc_sample.h"

void Manager_init(){
	
	Sensor_init(NXT_PORT_S1);//ZT[
	Sensor_init(NXT_PORT_S2);//EZT[
	Sensor_init(NXT_PORT_S3);//ZT[
	Motor_init(NXT_PORT_A);//E[^
	Motor_init(NXT_PORT_B);//[^
	Display_init();
	Battery_init();

	MotorController_init(0 );
	Nxt_init();
}

void Manager_carlibration(){
	//̂߂̃Lu[V

	Display_clear();
	Display_xy_string(0,0,"Put on Black\n");
	Display_xy_string(0,1,"Push ENTER button\n");
	Display_update();
	while (1){
		Nxt_set_black_value(Sensor_read_data(NXT_PORT_S3));
		if (Nxt_isEnterKey())//IW{^ꂽH
		{
			break; 
		}
		
	}
	Display_clear();
	Display_xy_int(0 , 0 , "Black value: "  , Nxt_get_black_value() , 0);
	Display_update();

	systick_wait_ms(1000); 

	//Lu[V

	Display_clear();
	Display_xy_string(0,0,"Put on White\n");
	Display_xy_string(0,1,"Push ENTER button\n");
	Display_update();
	while (1){
		Nxt_set_white_value(Sensor_read_data(NXT_PORT_S3));
		if (Nxt_isEnterKey())//IW{^ꂽH
		{
			break; 
		}
		
	}
	//XbVȟvZ
	Nxt_calc_threshold();

	systick_wait_ms(1000); 

	//S̒l\
	Display_clear();
	Display_xy_int(0 , 0 , "Black value: "  , Nxt_get_black_value() , 0);
	Display_xy_int(0 , 1 , "White value: "  , Nxt_get_white_value() , 0);
	Display_xy_int(0 , 2 , "Th    value: "  , Nxt_get_threshold_value() , 0);
	Display_update();

}

void Manager_loop(){
 	U16 left_val;
 	U16 right_val;
 	U16 light_val;
 	U16 batt_val;
	int pid;
	static int counter = 0;
  
	while(1) {
		wait_event();

		left_val  = Sensor_read_data(NXT_PORT_S1);
		right_val = Sensor_read_data(NXT_PORT_S2);
		light_val = Sensor_read_data(NXT_PORT_S3);
		pid = (int)MotorController_pid((double)left_val , 
					(double)((left_val + right_val)/2.0));
		MotorController_turn(-pid);
    
		if ( 0 == (counter++ % 100)){

			int i=0;
			Display_clear();
			Display_xy_int(0 , i++ , "Left: "  , left_val , 0);
			Display_xy_int(0 , i++ , "Right: " , right_val , 0);
			Display_xy_int(0 , i++ , "Light: " , light_val, 0);
			Display_xy_int(0 , i++ , "pid: "   , pid             , 0);
			Display_goto_xy(0, i++);
		
			Display_update();
		}
	}
}


