extern "C" {
#include <string.h>
#include "kernel.h"
#include "kernel_id.h"
#include "ecrobot_interface.h"
}
#include "display.h"

Display::Display(){}
void Display::init(){}
void Display::update(){
	display_update();
}
void Display::clear(){
	display_clear(0);
}
void Display::goto_xy(int x,int y){
	display_goto_xy(x,y);
}
void Display::string(const char * data){
	display_string(data);
}
void Display::hex(U32 data , int place){
	display_hex(data , place);
}
void Display::xy_int(int x , int y, const char* string , int disp , U32 place){
	display_goto_xy(x,y);
    display_string(string);
    display_int (disp , place);
}
void Display::xy_string(int x , int y, char* string){
	display_goto_xy(x,y);
    display_string(string);
}
void Display::xy_hex(int x , int y , U32 data , U32 place){
	display_goto_xy(x,y);
	display_hex(data , place);
}

