extern "C" {
#include <string.h>
#include "kernel.h"
#include "kernel_id.h"
#include "ecrobot_interface.h"
}
#include "getc2011_define.h"
#include "handler.h"
#include "motor.h"
#include "motor_controller.h"
#include "getc2011_sample.h"

MotorController::MotorController()
	:kp(0.5) , ki(0.00) , kd(0.027),delta(0.005){

	current  = 0.0;
	previous = 0.0;
	integral = 0.0;
	state = STATE_NO_RUN;

}
void MotorController::init( int f , Motor *l, Motor *r){
	foward = f;
	left = l;
	right = r;
}
double MotorController::pid(double sensor , double target){
	double p,i,d;
	previous = current;	
	current = sensor - target;
	integral += (current + previous) / 2.0 * delta;
	p = kp * current;
	i = ki * integral;
	d = kd * (current - previous) / delta;
	return (p + i + d);
}
void MotorController::run(int f)
{
	if (left && right){
		foward = f;
		left->run_motor(f);
		right->run_motor(f);
	}
}
void MotorController::stop()
{
	if (left && right){
		left->stop_motor();
		right->stop_motor();
		foward = 0;
	}
}
void MotorController::turn (int tn){
	if (0 != foward){
		if (left && right){
		if ( 20 < tn )	{tn =  20;}else{}
			if (-20 > tn )	{tn = -20;}else{}
				if (tn > 5){
				right->stop_motor();
				left->run_motor(tn * 5);
				}
			else if (tn < -5){
				left  ->stop_motor();
				right ->run_motor(-tn * 5);
			}
			else {
				run(foward);
			}
		}
	}
}
void MotorController::state_machine(int event){
	switch (state){
		case STATE_NO_RUN:
			if (EVENT_STOP == event){
				this->func_no_run_stop();
			}else if (EVENT_START == event){
				this->func_no_run_start();
				state = STATE_RUN;
			}
		break;
			case STATE_RUN:
			if (EVENT_STOP == event){
				this->func_run_stop();
				state = STATE_NO_RUN;
			}else if (EVENT_START == event){
				this->func_run_start();
			}
		break;
		default:
		break;
	}
}
void MotorController::func_no_run_start(){
	run(100);
}
void MotorController::func_no_run_stop (){
}
void MotorController::func_run_start(){
}
void MotorController::func_run_stop (){
	run(0);
}
void MotorController::timer_handler(){}//Ȃ

	//Cxgnh[ŏԑJڃ}VĂяo
void MotorController::event_handler(int event) {
	state_machine(event);
}

