#ifndef __MANAGER__
#define __MANAGER__

// CLASS Manager
//
// @class "Manager" @param "-reduce_counter:int,-left_sensor:Sensor*,-right_sensor:Sensor*,-light_sensor:Sensor*,-left_motor:Motor*,-right_motor:Motor*,-sonar:Sonar*,-bluetooth_slave:BlueTooth*,-disp:Display*,-batt:Battery*,-mc:MotorController*,-nxt:Nxt*,-timer_controller:TimerController*,-event_controller:EventController*,-pm:PcManager*,-pid:int,-counter:volatile int,-left_val:U16,-right_val:U16,-light_val:U16,-batt_val:U16" @func "+init():void,+carlibration():void,+timer_interrupt():void,+loop():void"

class Manager {
private:
	int reduce_counter;

	Sensor		*left_sensor	;
	Sensor		*right_sensor	;
	Sensor		*light_sensor	;
	Motor		*left_motor		;
	Motor		*right_motor	;
	Sonar		*sonar			;
	BlueTooth	*bluetooth_slave;
	Display		*disp			;
	Battery		*batt			;
	MotorController  *mc		;
	Nxt			*nxt;
	TimerController *timer_controller;
	EventController *event_controller;
	PcManager *pm;
	
	int pid;
	volatile int counter;
	U16 left_val;
	U16 right_val;
	U16 light_val;
	U16 batt_val;

public:
	Manager();
	void init();
	void carlibration();
	void timer_interrupt();
	void loop ();
	
};
#endif
