extern "C" {
#include <string.h>
#include "kernel.h"
#include "kernel_id.h"
#include "ecrobot_interface.h"
}

#include "getc2011_define.h"
#include "handler.h"
#include "event_controller.h"


EventController::EventController(){
	counter = 0;
	for (int i = 0 ; i < MAX_OBJECT ; i++){
		object[i] = (Handler*)null;
	}
}
	
void EventController::regist_event(Handler *obj){
	if (MAX_OBJECT > counter){
		object[counter++] = obj;    // set AIuWFNg
	}
}
void EventController::event_occured(int event){
	Handler *obj;
	for ( int i = 0 ; i < MAX_OBJECT ; i++){
			obj = object[i];
		if (null != obj){
			obj->event_handler(event);
		}
	}
}
